/*
 * Turtle.java
 *
 * Created on 09 August 2004, 00:23
 *
 * This class is responsible for keeping the position
 * and orientation of the drawing procedure
 *
 * @author  Alexander Dimitropoulos
 * @version 1
 */
public class Turtle {
    
    private double x;
    private double y;
    private double a;
    private double d;
    
    
    
    /** Creates a new instance of Turtle */
    public Turtle() {
        
    }
    
    /**
     * Initiating a turtle object given the values
     * of x-coordinate, y-coordinate, the direction angle
     * and the drawing distance
     */
    public Turtle(double x, double y, double alpha, double dist) {
        this.x = x;
        this.y = y;
        a = alpha;
        d = dist;
    }
    
    /**
     * Set of accessor methods
     * Used to get turtle values
     */
    public double getX() {
        return x;
    }
    
    public double getY() {
        return y;
    }
    
    public double getAlpha() {
        return a;
    }
    
    public double getD() {
        return d;
    }
    
    /**
     * Set of mutator methods
     * used to change turtle values
     *
     * @param x     the x-coordinate of the turtle
     */
    public void setX(double x) {
        this.x = x;
    }
    
    // @param y     the y-coordinate of the turtle
    public void setY(double y) {
        this.y = y;
    }
    
    // @param alpha     the direction angle
    public void setAlpha(double alpha) {
        a = alpha;
    }
    
    // @param dist      the drawing distance of the turtle
    public void setD(double dist) {
        d = dist;
    }
    
    // @param delta     increase the angle by delta
    public void incrAlpha(double delta) {
        a += delta;
    }
    
    // @param delta     decrease the angle by delta
    public void decrAlpha(double delta) {
        a -= delta;
    }
}
