/*
 * Class.java
 *
 * Created on 04 August 2004, 01:34
 *
 * This class is responsible for drawing a two-dimensional L-System
 * Two options are available: leaves and colour.
 * The leaves option adds leaves to the model
 * The colour option sets the colour of each section to brown
 * and green for the leaves, in case leaves option.
 *
 * @author  Alexander Dimitropoulos
 * @version 2
 */
import java.awt.*;
import javax.swing.*;
import java.lang.Math;
import java.awt.geom.*;
import java.util.Stack;


public class DrawTree extends JFrame{
    
    private String treestr;
    private double delta;
    private Stack TurtleStack;
    private Turtle turtle;    
    private boolean leaves;
    private boolean colour;
    
    /**
     * Creates a new instance of Class
     * the inputs are the generation string
     * the angle change, the length of the drawn section
     * and booleans to set leaves and colour
     */
    public DrawTree(String treestr, double angle, float length, boolean leaves, boolean colour) { 
        super("2D Model");
                   
        this.treestr = treestr;
        delta = Math.toRadians(angle);   
        TurtleStack = new Stack();
        turtle = new Turtle();
        turtle.setD(length);
        this.leaves = leaves;
        this.colour = colour;
        
        setSize(1024, 768);
        show();        
    }
    
    private double getDelta() {
        return delta;
    }
    
    /**
     * this method draws the corresponding image
     * for the given L-System
     */
    public void paint(Graphics g) {
                
        Graphics2D g2d = (Graphics2D) g;
        
        Color c = new Color(110,90,50); //setting brown colour (stem)
        Color leaf = Color.GREEN;       //setting drawing colour
        if (colour)
            g2d.setColor(c);
        
        
        char tree[] = treestr.toCharArray();
        char TreeChar;
        
        turtle.setX(400);
        turtle.setY(500);
        turtle.setAlpha(1.5*Math.PI); //Alpha in radians
        double xnew;
        double ynew;
        
        for (int i=0; i<tree.length; i++) {
            
            TreeChar = tree[i];
            
            if (TreeChar=='F') {
                
                //assign the location of the next point (node)
                xnew = turtle.getX() + turtle.getD() * Math.cos(turtle.getAlpha());
                ynew = turtle.getY() + turtle.getD() * Math.sin(turtle.getAlpha());
                
                g2d.draw(new Line2D.Double(turtle.getX(),turtle.getY(),xnew,ynew));
                
                turtle.setX(xnew);
                turtle.setY(ynew);
            }
            
            else if (TreeChar == '+') {  
                
                //increase Alpha by delta
                turtle.incrAlpha(delta);
            }
            
            else if (TreeChar == '-') {
                
                //decrease Alpha by delta
                turtle.decrAlpha(delta);
            }
            
            else if (TreeChar == 'f') {
                
                xnew = turtle.getX()
                        + turtle.getD() * Math.cos(turtle.getAlpha());
                ynew = turtle.getY()
                        + turtle.getD() * Math.sin(turtle.getAlpha());
                
                turtle.setX(xnew);
                turtle.setY(ynew);
            }
            
            else if (TreeChar == '[') {
                
                //Create a new turtle object with present values
                Turtle tempturtle = new Turtle(turtle.getX(),turtle.getY(),
                turtle.getAlpha(),turtle.getD());
                
                //Push current state of turtle orientation in stack
                TurtleStack.push(tempturtle);
            }
            
            else if (TreeChar == ']') {
                
                /**
                 * drawing leafs at the end of every branch
                 */
                if (leaves) {
                    
                    /**
                     *Assigning parameters for tree draw:
                     *start point, end point, curvature point
                     */
                    double leafXend = turtle.getX() 
                        + 2 * turtle.getD() * Math.cos(turtle.getAlpha());
                    double leafYend = turtle.getY()
                        + 2 * turtle.getD() * Math.sin(turtle.getAlpha());

                    double leafXa = turtle.getX()
                        + turtle.getD() * Math.cos(turtle.getAlpha())/2
                        - turtle.getD() * Math.cos(Math.toRadians(90)-turtle.getAlpha()) /2;
                    double leafYa = turtle.getY() 
                        + turtle.getD() * Math.sin(turtle.getAlpha()) /2
                        + turtle.getD() * Math.sin(Math.toRadians(90)-turtle.getAlpha()) /2;

                    double leafXb = turtle.getX() 
                        + turtle.getD() * Math.cos(turtle.getAlpha())/2
                        + turtle.getD() * Math.cos(Math.toRadians(90)-turtle.getAlpha()) /2;
                    double leafYb = turtle.getY() 
                        + turtle.getD() * Math.sin(turtle.getAlpha()) /2
                        - turtle.getD() * Math.sin(Math.toRadians(90)-turtle.getAlpha()) /2;
                    
                    // Setting draw colour to leaf colour (green)
                    if (colour)
                        g2d.setColor(leaf);
                    
                    //draw two, oposite, filled QuadCurves that make a leaf
                    g2d.fill(new QuadCurve2D.Double(turtle.getX(),
                        turtle.getY(),leafXa,leafYa,leafXend,leafYend));
                    g2d.fill(new QuadCurve2D.Double(turtle.getX(),
                        turtle.getY(),leafXb,leafYb,leafXend,leafYend));

                    //reset drawing colour to brown (stem)
                    if (colour)
                        g2d.setColor(c);
                }
                
                //remove top turtle from stack and assign it to current turtle
                turtle = (Turtle) TurtleStack.pop();
                
            } //end character ']'
            
            else {
                //do nothing
            }
        }
    }
}
